/*
 * Decompiled with CFR 0.152.
 */
package com.dfdyz.epicacg.config;

import com.dfdyz.epicacg.registry.Particles;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import yesman.epicfight.api.client.animation.property.TrailInfo;
import yesman.epicfight.api.client.model.ItemSkin;

public class Trail {
    public float x;
    public float y;
    public float z;
    public float ex;
    public float ey;
    public float ez;
    public int r;
    public int g;
    public int b;
    public int a;
    public int lifetime;
    public int interpolations = 8;
    public String textureRegisterId = "";
    public String particleId = "";

    public Trail(float x, float y, float z, float ex, float ey, float ez, int r, int g, int b, int a) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.ex = ex;
        this.ey = ey;
        this.ez = ez;
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
        this.lifetime = 3;
    }

    public Trail(float x, float y, float z, float ex, float ey, float ez, int r, int g, int b, int a, String texture) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.ex = ex;
        this.ey = ey;
        this.ez = ez;
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
        this.lifetime = 3;
        this.textureRegisterId = texture;
    }

    public Trail(float x, float y, float z, float ex, float ey, float ez, int r, int g, int b, int a, int lifetime) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.ex = ex;
        this.ey = ey;
        this.ez = ez;
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
        this.lifetime = lifetime;
    }

    public Trail CopyColFrom(Trail col) {
        this.r = col.r;
        this.g = col.g;
        this.b = col.b;
        this.a = col.a;
        return this;
    }

    public Trail CopyPosFrom(Trail pos) {
        this.x = pos.x;
        this.y = pos.y;
        this.z = pos.z;
        this.ex = pos.ex;
        this.ey = pos.ey;
        this.ez = pos.ez;
        return this;
    }

    public Trail CopyFrom(Trail org) {
        this.x = org.x;
        this.y = org.y;
        this.z = org.z;
        this.ex = org.ex;
        this.ey = org.ey;
        this.ez = org.ez;
        this.r = org.r;
        this.g = org.g;
        this.b = org.b;
        this.a = org.a;
        this.lifetime = org.lifetime;
        this.interpolations = org.interpolations;
        this.textureRegisterId = org.textureRegisterId;
        return this;
    }

    public Trail() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
        this.ex = 0.0f;
        this.ey = 0.0f;
        this.ez = 0.0f;
        this.r = 0;
        this.g = 0;
        this.b = 0;
        this.a = 0;
        this.lifetime = 0;
    }

    public void Clear() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
        this.ex = 0.0f;
        this.ey = 0.0f;
        this.ez = 0.0f;
        this.r = 0;
        this.g = 0;
        this.b = 0;
        this.a = 0;
        this.lifetime = 0;
        this.interpolations = 8;
        this.textureRegisterId = "";
    }

    public ItemSkin toItemSkin() {
        TrailInfo.Builder trailInfo = TrailInfo.builder();
        trailInfo.startPos(new Vec3((double)this.x, (double)this.y, (double)this.z));
        trailInfo.endPos(new Vec3((double)this.ex, (double)this.ey, (double)this.ez));
        trailInfo.r((float)this.r / 255.0f);
        trailInfo.g((float)this.g / 255.0f);
        trailInfo.b((float)this.b / 255.0f);
        trailInfo.lifetime(this.lifetime);
        trailInfo.interpolations(this.interpolations);
        if (this.textureRegisterId.equals("")) {
            trailInfo.texture("epicfight:textures/particle/swing_trail.png");
        } else {
            trailInfo.texture(this.textureRegisterId);
        }
        System.out.println(this.textureRegisterId);
        SimpleParticleType particleType = (SimpleParticleType)Particles.BLOOM_TRAIL.get();
        if (this.particleId != "" && ForgeRegistries.PARTICLE_TYPES.containsKey(new ResourceLocation(this.particleId))) {
            particleType = (SimpleParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(new ResourceLocation(this.particleId));
        }
        trailInfo.type(particleType);
        ItemSkin itemSkin = new ItemSkin(trailInfo.create(), false);
        return itemSkin;
    }
}

